Imports EJRandomOrgConsumer
Public Class Form1


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load


        InitializeRandomizationMethods()


    End Sub


    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing


    End Sub


#Region " Randomization Method Option Management "


    Private Sub InitializeRandomizationMethods()


        Dim DefaultRandomizationText As String = GetGuidPiece(15)
        Dim DefaultRandomizationDate As Date = DateAdd(DateInterval.Day, -1, Now())


        InitializeRandomizationMethods(Me.comboIntGen_RandomizationMethod, Me.txtIntGen_RandomizationIdentifier, Me.txtIntGen_RandomizationDate, DefaultRandomizationText, DefaultRandomizationDate)
        InitializeRandomizationMethods(Me.comboSeqGen_RandomizationMethod, Me.txtSeqGen_RandomizationIdentifier, Me.txtSeqGen_RandomizationDate, DefaultRandomizationText, DefaultRandomizationDate)
        InitializeRandomizationMethods(Me.comboStrGen_RandomizationMethod, Me.txtStrGen_RandomizationIdentifier, Me.txtStrGen_RandomizationDate, DefaultRandomizationText, DefaultRandomizationDate)


    End Sub


    Private Sub InitializeRandomizationMethods(ByRef comboRandomizationMethod As ComboBox, ByRef txtRandomizationIdentifier As TextBox, ByRef txtRandomizationDate As TextBox, ByVal DefaultRandomizationIdentifier As String, ByVal DefaultRandomizationDate As Date)


        Dim CurMethod As String


        txtRandomizationIdentifier.Text = DefaultRandomizationIdentifier
        txtRandomizationIdentifier.Visible = False

        txtRandomizationDate.Text = DefaultRandomizationDate.ToString("yyyy-MM-dd")
        txtRandomizationDate.Top = txtRandomizationIdentifier.Top
        txtRandomizationDate.Visible = False

        comboRandomizationMethod.Items.Clear()
        For Each CurMethod In [Enum].GetNames(GetType(EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods))
            comboRandomizationMethod.Items.Add(CurMethod)
        Next
        comboRandomizationMethod.SelectedIndex = 0


    End Sub


    Private Sub comboIntGen_RandomizationMethod_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles comboIntGen_RandomizationMethod.SelectedIndexChanged


        HandleRandomizationMethodChange(Me.comboIntGen_RandomizationMethod, Me.txtIntGen_RandomizationIdentifier, Me.txtIntGen_RandomizationDate)


    End Sub


    Private Sub comboSeqGen_RandomizationMethod_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles comboSeqGen_RandomizationMethod.SelectedIndexChanged


        HandleRandomizationMethodChange(Me.comboSeqGen_RandomizationMethod, Me.txtSeqGen_RandomizationIdentifier, Me.txtSeqGen_RandomizationDate)


    End Sub


    Private Sub comboStrGen_RandomizationMethod_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles comboStrGen_RandomizationMethod.SelectedIndexChanged


        HandleRandomizationMethodChange(Me.comboStrGen_RandomizationMethod, Me.txtStrGen_RandomizationIdentifier, Me.txtStrGen_RandomizationDate)


    End Sub


    Private Sub HandleRandomizationMethodChange(ByRef comboRandomizationMethod As ComboBox, ByRef txtRandomizationIdentifier As TextBox, ByRef txtRandomizationDate As TextBox)


        Dim rmSelected As EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods


        Try

            'By default, don't show the argument fields.
            txtRandomizationIdentifier.Visible = False
            txtRandomizationDate.Visible = False

            If comboRandomizationMethod.Text <> "" Then

                rmSelected = [Enum].Parse(GetType(EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods), comboRandomizationMethod.Text, True)
                Select Case rmSelected
                    Case StructuresAndEnums.RandomizationMethods.IdentifierBased
                        txtRandomizationIdentifier.Visible = True
                    Case StructuresAndEnums.RandomizationMethods.DateBased
                        txtRandomizationDate.Visible = True
                End Select

            End If

        Catch ex As Exception

        End Try


    End Sub


    Private Function GetGuidPiece() As String


        Return GetGuidPiece(32)


    End Function


    Private Function GetGuidPiece(ByVal Length As Byte) As String


        Dim GuidValue As String = ""
        Dim gGuid As Guid


        Try

            gGuid = Guid.NewGuid()
            GuidValue = gGuid.ToString().ToUpper()
            GuidValue = GuidValue.Replace("-", "")
            If GuidValue.Length > Length Then GuidValue = GuidValue.Substring(0, Length)

        Catch ex As Exception

        Finally

            gGuid = Nothing

        End Try


        Return GuidValue


    End Function


#End Region


#Region " Events for the Main Buttons "


    Private Sub btnIntGen_GetIntegers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnIntGen_GetIntegers.Click


        GetIntegers()


    End Sub


    Private Sub btnSeqGen_GetSequence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSeqGen_GetSequence.Click


        GetSequence()


    End Sub


    Private Sub btnStrGen_GetStrings_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStrGen_GetStrings.Click


        GetStrings()


    End Sub


    Private Sub btnQuoChk_GetRemainingBits_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnQuoChk_GetRemainingBits.Click


        GetRemainingBits()


    End Sub


#End Region


#Region " Main Subs/Functions "


    Private Sub GetIntegers()


        Dim igConsumer As IntegerGenerator = Nothing
        Dim qcConsumer As QuotaChecker = Nothing
        Dim RandomIntegers() As Integer
        Dim RandomInteger As Integer


        Try

            'First, make sure we haven't exceeded our quota.
            qcConsumer = New QuotaChecker()
            If qcConsumer.GetRemainingBits() <= 0 Then

                MsgBox("The quota has been exceeded.  Please wait for the quota to be replenished, or buy more bits at http://random.org/quota/ .")

            Else

                'Create a new instance of the consumer class.
                igConsumer = New IntegerGenerator()


                'Define the property values.
                'In real life, you'd want some validation here for user-entered values.
                With igConsumer

                    .Quantity = CType(Me.txtIntGen_Quantity.Text, Integer)
                    .Range = New EJRandomOrgConsumer.StructuresAndEnums.ValueRange(CType(Me.txtIntGen_MinValue.Text, Integer), CType(Me.txtIntGen_MaxValue.Text, Integer))
                    .RandomizationMethod = [Enum].Parse(GetType(EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods), Me.comboIntGen_RandomizationMethod.Text, True)
                    Select Case .RandomizationMethod
                        Case StructuresAndEnums.RandomizationMethods.IdentifierBased
                            .RandomizationIdentifier = Me.txtIntGen_RandomizationIdentifier.Text
                        Case StructuresAndEnums.RandomizationMethods.DateBased
                            .RandomizationDate = CType(Me.txtIntGen_RandomizationDate.Text, Date)
                    End Select

                End With


                'Get the results.
                RandomIntegers = igConsumer.GetIntegers()


                'Did we get anything?
                If (RandomIntegers Is Nothing) OrElse (RandomIntegers.Length <= 0) Then
                    MsgBox("No results")
                Else

                    'Populate the list with our results.
                    Me.lvIntGen_Results.Items.Clear()
                    For Each RandomInteger In RandomIntegers
                        Me.lvIntGen_Results.Items.Add(RandomInteger.ToString())
                    Next

                    'Let the user know we've finished.
                    Me.lblIntGen_LastUpdated.Text = "Last Updated: " & Now().ToString("yyyy-MM-dd h:mm:ss.f tt")

                End If

            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        Finally

            If TypeOf qcConsumer Is QuotaChecker Then qcConsumer.Dispose()
            qcConsumer = Nothing

            If TypeOf igConsumer Is IntegerGenerator Then igConsumer.Dispose()
            igConsumer = Nothing

            RandomIntegers = Nothing

        End Try


    End Sub


    Private Sub GetSequence()


        Dim sgConsumer As SequenceGenerator = Nothing
        Dim qcConsumer As QuotaChecker = Nothing
        Dim RandomIntegers() As Integer
        Dim RandomInteger As Integer


        Try

            'First, make sure we haven't exceeded our quota.
            qcConsumer = New QuotaChecker()
            If qcConsumer.GetRemainingBits() <= 0 Then

                MsgBox("The quota has been exceeded.  Please wait for the quota to be replenished, or buy more bits at http://random.org/quota/ .")

            Else

                'Create a new instance of the consumer class.
                sgConsumer = New SequenceGenerator()


                'Define the property values.
                'In real life, you'd want some validation here for user-entered values.
                With sgConsumer

                    .Range = New EJRandomOrgConsumer.StructuresAndEnums.ValueRange(CType(Me.txtSeqGen_MinValue.Text, Integer), CType(Me.txtSeqGen_MaxValue.Text, Integer))
                    .RandomizationMethod = [Enum].Parse(GetType(EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods), Me.comboSeqGen_RandomizationMethod.Text, True)
                    Select Case .RandomizationMethod
                        Case StructuresAndEnums.RandomizationMethods.IdentifierBased
                            .RandomizationIdentifier = Me.txtSeqGen_RandomizationIdentifier.Text
                        Case StructuresAndEnums.RandomizationMethods.DateBased
                            .RandomizationDate = CType(Me.txtSeqGen_RandomizationDate.Text, Date)
                    End Select

                End With


                'Get the results.
                RandomIntegers = sgConsumer.GetSequence()


                'Did we get anything?
                If (RandomIntegers Is Nothing) OrElse (RandomIntegers.Length <= 0) Then
                    MsgBox("No results")
                Else

                    'Populate the list with our results.
                    Me.lvSeqGen_Results.Items.Clear()
                    For Each RandomInteger In RandomIntegers
                        Me.lvSeqGen_Results.Items.Add(RandomInteger.ToString())
                    Next

                    'Let the user know we've finished.
                    Me.lblSeqGen_LastUpdated.Text = "Last Updated: " & Now().ToString("yyyy-MM-dd h:mm:ss.f tt")

                End If

            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        Finally

            If TypeOf qcConsumer Is QuotaChecker Then qcConsumer.Dispose()
            qcConsumer = Nothing

            If TypeOf sgConsumer Is SequenceGenerator Then sgConsumer.Dispose()
            sgConsumer = Nothing

            RandomIntegers = Nothing

        End Try


    End Sub


    Private Sub GetStrings()


        Dim sgConsumer As StringGenerator = Nothing
        Dim qcConsumer As QuotaChecker = Nothing
        Dim RandomStrings() As String
        Dim RandomString As String


        Try

            'First, make sure we haven't exceeded our quota.
            qcConsumer = New QuotaChecker()
            If qcConsumer.GetRemainingBits() <= 0 Then

                MsgBox("The quota has been exceeded.  Please wait for the quota to be replenished, or buy more bits at http://random.org/quota/ .")

            Else

                'Create a new instance of the consumer class.
                sgConsumer = New StringGenerator()


                'Define the property values.
                'In real life, you'd want some validation here for user-entered values.
                With sgConsumer

                    .Quantity = CType(Me.txtStrGen_Quantity.Text, Integer)
                    .StringLength = CType(Me.txtStrGen_StringLength.Text, Integer)
                    .AllowNumbers = Me.radStrGen_AllowNumbers_Yes.Checked
                    .AllowUppercaseAlpha = Me.radStrGen_AllowUppercaseAlpha_Yes.Checked
                    .AllowLowercaseAlpha = Me.radStrGen_AllowLowercaseAlpha_Yes.Checked
                    .EnsureUnique = Me.radStrGen_EnsureUnique_Yes.Checked
                    .RandomizationMethod = [Enum].Parse(GetType(EJRandomOrgConsumer.StructuresAndEnums.RandomizationMethods), Me.comboStrGen_RandomizationMethod.Text, True)
                    Select Case .RandomizationMethod
                        Case StructuresAndEnums.RandomizationMethods.IdentifierBased
                            .RandomizationIdentifier = Me.txtIntGen_RandomizationIdentifier.Text
                        Case StructuresAndEnums.RandomizationMethods.DateBased
                            .RandomizationDate = CType(Me.txtIntGen_RandomizationDate.Text, Date)
                    End Select

                End With


                'Get the results.
                RandomStrings = sgConsumer.GetStrings()


                'Did we get anything?
                If (RandomStrings Is Nothing) OrElse (RandomStrings.Length <= 0) Then
                    MsgBox("No results")
                Else

                    'Populate the list with our results.
                    Me.lvStrGen_Results.Items.Clear()
                    For Each RandomString In RandomStrings
                        Me.lvStrGen_Results.Items.Add(RandomString.ToString())
                    Next

                    'Let the user know we've finished.
                    Me.lblStrGen_LastUpdated.Text = "Last Updated: " & Now().ToString("yyyy-MM-dd h:mm:ss.f tt")

                End If

            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        Finally

            If TypeOf qcConsumer Is QuotaChecker Then qcConsumer.Dispose()
            qcConsumer = Nothing

            If TypeOf sgConsumer Is StringGenerator Then sgConsumer.Dispose()
            sgConsumer = Nothing

            RandomStrings = Nothing

        End Try


    End Sub


    Private Sub GetRemainingBits()


        Dim qcConsumer As QuotaChecker = Nothing
        Dim BitsRemaining As Integer = 0


        Try

            'Create a new instance of the consumer class.
            qcConsumer = New QuotaChecker()


            'Define the property values.
            'In real life, you'd want some validation here for user-entered values.
            With qcConsumer

                .IPAddress = Me.txtQuoChk_IPAddress.Text.Trim()

            End With


            'Get the results.
            BitsRemaining = qcConsumer.GetRemainingBits()


            'Populate the list with our results.
            Me.lvQuoChk_Results.Items.Clear()
            Me.lvQuoChk_Results.Items.Add(BitsRemaining.ToString())


            'Let the user know we've finished.
            Me.lblQuoChk_LastUpdated.Text = "Last Updated: " & Now().ToString("yyyy-MM-dd h:mm:ss.f tt")


        Catch ex As Exception

            MsgBox(ex.Message)

        Finally

            If TypeOf qcConsumer Is QuotaChecker Then qcConsumer.Dispose()
            qcConsumer = Nothing

        End Try


    End Sub


#End Region


End Class
